const DomainStatusPriority = [
    'master',
    'delegated',
    'mx',
    'owned',
    'other',
];

function byName(x, y) {
    if (x.name === y.name) {
        return 0;
    }

    return x.name > y.name ? 1 : -1;
}

export default function sortDomainsByRelevance(domains) {
    let groups = DomainStatusPriority
        .reduce((map, key) => (map[key] = []) && map, {});

    for (let i = 0; i < domains.length; i++) {
        let groupKey = DomainStatusPriority.find(prop => domains[i][prop] === true);

        groups[groupKey || 'other'].push(domains[i]);
    }

    return DomainStatusPriority
        .reduce((acc, key) => acc.concat(groups[key].sort(byName)), []);
}
