const LayerMap = {
    people: 'user',
    departments: 'department',
    groups: 'group',
};

export default function toDirectoryObject(searchObject) {
    let { layer, id, title, avatar_url: avatarUrl, login } = searchObject;

    return {
        type: LayerMap[layer],
        object: {
            id,
            name: title,
            avatar_url: avatarUrl,
            nickname: login,
        },
    };
}
