// некоторые ссылки внутри Коннекта бэкенд отдаёт абсолютными,
// чтобы ими могли пользоваться внешние потребители API;
// внутри Коннекта в браузере часто удобно иметь дело с относительными ссылками,
// потому что одному тестовому окружению может соответствовать несколько хостов
export default function truncateOwnHost(url) {
    if (/^(https?:)?\/\/connect(\-[^\.]+\.ws)?\.yandex(\.\w+)?.\w+\b/.test(url)) {
        let { href, origin } = new URL(/^\/\//.test(url) ? `https:${url}` : url);

        return href.substring(origin.length);
    }

    return url;
}
