import Immutable from 'immutable';
import _ from 'lodash';

const DEFAULT_PROPS = {
    type: undefined,
    items: undefined, // собственно элементы чанка
    collected_items: undefined, // все элементы, собранные из чанков с тем же ключом
    pages: undefined,
    per_page: undefined,
    total: undefined,
    page: undefined,
    chunk_size: undefined,
    last: undefined,
};

class Chunk extends Immutable.Record(DEFAULT_PROPS) {
    static create(data = {}) {
        const nextData = _.pick(data, Object.keys(DEFAULT_PROPS));

        // поле 'size' зарезервировано в Record, переименовываем в 'chunk_size'
        if (data.size !== undefined) {
            nextData.chunk_size = data.size;
        }

        return new Chunk(Immutable.fromJS(nextData));
    }

    isLast() {
        return this.get('last');
    }

    getPage() {
        return this.get('page');
    }

    getItems() {
        const items = this.get('items');

        return items ? items.toArray() : [];
    }

    getCollectedItems() {
        const items = this.get('collected_items');

        return items ? items.toArray() : [];
    }

    getSize() {
        return this.get('chunk_size');
    }

    getMaxSize() {
        return this.get('per_page');
    }
}

export default Chunk;
