import Immutable from 'immutable';

const DEFAULT_FIELDS = {
    enabled: undefined,
    domain: undefined,
    changed: undefined,
    selector: undefined,
    public_key: undefined,
    pending: undefined,
};

class Dkim extends Immutable.Record(DEFAULT_FIELDS) {
    static PRIMARY_KEY = 'domain';
    static TYPE_NAME = 'dkim';

    static create(data) {
        return new Dkim(Immutable.fromJS(data));
    }

    getType() {
        return Dkim.TYPE_NAME;
    }

    getName() {
        return this.get(Dkim.PRIMARY_KEY);
    }

    getPublicKey() {
        return this.get('public_key');
    }

    isEnabled() {
        return this.get('enabled');
    }

    isPending() {
        return this.get('pending');
    }
}

export default Dkim;
