import Immutable from 'immutable';

const DEFAULT_FIELDS = {
    master: false,
    tech: false,
    owned: false,
    mx: false,
    name: '',
    delegated: false,
};

class Domain extends Immutable.Record(DEFAULT_FIELDS) {
    static PRIMARY_KEY = 'name';
    static TYPE_NAME = 'domain';

    static create(data) {
        return new Domain(Immutable.fromJS(data));
    }

    getType() {
        return Domain.TYPE_NAME;
    }

    getName() {
        return this.get(Domain.PRIMARY_KEY);
    }

    getStatus() {
        if (!this.isOwned()) {
            return 'not_confirmed';
        }

        if (!this.hasMxRecord()) {
            return 'no_mx';
        }

        if (this.isDelegated()) {
            return 'delegated';
        }

        return 'confirmed';
    }

    isOwned() {
        return this.get('owned');
    }

    hasMxRecord() {
        return this.get('mx');
    }

    isDelegated() {
        return this.get('delegated');
    }

    isMaster() {
        return this.get('master');
    }

    isTechnical() {
        return this.get('tech');
    }
}

export default Domain;
