import _ from 'lodash';
import Immutable from 'immutable';

const DEFAULTS = {
    code: undefined,
    org_name: undefined,
    valid: false,
};

class Invite extends Immutable.Record(DEFAULTS) {
    static PRIMARY_KEY = 'code';
    static TYPE_NAME = 'session';

    static create(data) {
        const nextData = _.pick(data, Object.keys(DEFAULTS));

        return new Invite(Immutable.fromJS(nextData));
    }

    getId() {
        return this.get(Invite.PRIMARY_KEY);
    }

    getType() {
        return Invite.TYPE_NAME;
    }

    equals(x) {
        return (x instanceof Invite) && x.getId() === this.getId();
    }

    getOrganizationName() {
        return this.get('org_name');
    }

    isValid() {
        return this.get('valid');
    }

    getCode() {
        return this.get('code');
    }
}

export default Invite;
