import Immutable from 'immutable';

const DEFAULTS = {
    id: undefined,
    type: undefined,
};

class Service extends Immutable.Record(DEFAULTS) {
    static PRIMARY_KEY = 'id';
    static TYPE_NAME = 'service';

    static create(data) {
        return new Service(Immutable.fromJS(data));
    }

    getId() {
        return this.get(Service.PRIMARY_KEY);
    }

    getType() {
        return Service.TYPE_NAME;
    }
}

export default Service;
