import ReactDOM from 'react-dom';

/*
import _ from 'lodash';
import withinViewport from 'lib/withinViewport';

const VIEWPORT_MARGINS = {
    topMargin: 300,
    bottomMargin: 300
};
*/

function toKey(x) {
    return x instanceof Array ? x.join('/') : x;
}

const ListManager = {

    addListItem(key, component, handlers = {}) {
        const storage = this.getStorage(key);
        const element = ReactDOM.findDOMNode(component);

        storage.items.push({
            component,
            element,
            click: handlers.click || component._handleClick,
            scroll: handlers.scroll || component._handleScroll,
        });
    },

    /*
    displays(key, component) {
        return withinViewport(component, VIEWPORT_MARGINS);
    },
    */

    displays() {
        return true;
    },

    removeListItem(key, component) {
        let index;
        const storage = this.getStorage(key);

        if (typeof component === 'number') {
            index = component;
        } else {
            for (let i = 0, n = storage.items.length; i < n && index === undefined; i++) {
                if (storage.items[i].component === component) {
                    index = i;
                }
            }
        }

        if (index !== undefined) {
            storage.items.splice(index, 1);
        }
    },

    getScrollHandler() {
        return null;
    },

    /*
    getScrollHandler(key) {
        var storage = this.getStorage(key);

        return _.throttle(options => {
            storage.items.forEach(item => {
                var { component, element, scroll } = item;
                if (!component.state.viewable && component.isMounted()) {
                    ((component, element, scroll) => {
                    setTimeout(() => {
                        component.setState({
                            viewable: withinViewport(element, options, VIEWPORT_MARGINS)
                        });
                        if (scroll) {
                            scroll(options);
                        }
                    }, 0);
                    })(component, element, scroll);
                }
            });
        }, 200);
    },
    */

    getClickHandler(key) {
        const storage = this.getStorage(key);

        return event => {
            storage.items.forEach(item => {
                const { element, click } = item;
                const clicked = element &&
                    event.target === element || element.contains(event.target);

                if (clicked && click) {
                    click(event);
                }
            });
        };
    },

    discard(key) {
        key = toKey(key);

        if (this._storage[key]) {
            this._storage[key] = null;
            delete this._storage[key];
        }
    },

    getStorage(key) {
        key = toKey(key);

        if (!this._storage[key]) {
            this._storage[key] = { items: [] };
        }

        return this._storage[key];
    },

    _storage: {},

};

export default window.ya.connect.ListManager = ListManager;
