import cookie from 'js-cookie';
import AuthStore from 'stores/Auth';

export default {
    requireAuthorization,
    startSession,
    isCurrentSession,
};

/**
 * Обрабатывет потерю авторизации
 * @method requireAuthorization
 */
function requireAuthorization() {
    window.location.href = AuthStore.getAuthUrl();
}

/**
 * Обрабатывет смену пользователя
 * @method startSession
 */
function startSession() {
    cookie.remove('access_recently_denied', { path: '/' });
    window.location.href = '/';
}

/**
 * Проверка текущего пользователя
 * @method isCurrentSession
 * @param {String} uid
 * @returns {Boolean} true - если пользователь тот же, false - если изменился
 */
function isCurrentSession(uid) {
    return uid === AuthStore.getUserId();
}
