import { Dispatcher } from 'flux';
import log from 'services/log';

class AppDispatcher extends Dispatcher {
    dispatch(type, data = null) {
        return super.dispatch.call(this, { type, data });
    }
}

const dispatcher = new AppDispatcher();

// @if NODE_ENV='development'
dispatcher.register(action => {
    const { type, data } = action;

    log.info('%c[action] type: %s, data: %O', 'color: #5569DA', type, data);
});
// @endif

export default window.ya.connect.dispatcher = dispatcher;
