/**
 * Синглтон для работы с историей браузера
 */

import createHistory from 'history/lib/createBrowserHistory';
import { ActionTypes } from 'constants/Common';
import dispatcher from 'dispatcher';
import { RouteTiming } from 'lib/rum';

const history = createHistory();

/**
 * Обработчик, который вызывается перед изменением history
 */
history.listenBefore(() => {
    dispatcher.dispatch(ActionTypes.BEFORE_CHANGE_HISTORY);
});

/**
 * Обработчик, который вызывается после изменения history
 */
history.listen(() => {
    dispatcher.dispatch(ActionTypes.CHANGE_HISTORY);
    RouteTiming.start();
});

export default history;
