import { ActionTypes } from 'constants/Common';
import dispatcher from 'dispatcher';
import { i18n } from 'lib/i18n';

/**
 * Нотификации об ошибках и прочих статусах
 * @param {String}  message
 * @param {String}  type     info | warning | error | success
 * @param {?Object} options  дополнительные данные
 */
function notify(message, type, options) {
    dispatcher.dispatch(ActionTypes.NOTIFY, { message, type, options });
}

export function sendRequestErrorNotification(error) {
    dispatcher.dispatch(ActionTypes.SEND_BACKGROUND_NOTIFICATION, {
        key: error,
        message: i18n('common.request_error'),
        type: 'error',
    });
    dispatcher.dispatch(ActionTypes.END_PROCESS);
}

export function cancelRequestErrorNotification(error) {
    dispatcher.dispatch(ActionTypes.CANCEL_BACKGROUND_NOTIFICATION, {
        key: error,
    });
}

export default window.ya.connect.notify = notify;
