import notify from 'services/notify';
import { i18n } from 'lib/i18n';

function submit(request, options = {}) {
    return request
        .then(response => {
            if (response && response.errors) {
                const message = response.errors.get('_common') ||
                    i18n('errors.unknown') || 'Unknown error';

                notify(message, 'error');
            } else {
                notify(options.success, 'success');
            }
        })
        .catch(error => {
            notify(options.failure, 'error', error);

            throw error;
        });
}

export default submit;
