import Immutable from 'immutable';
import { ReduceStore } from 'flux/utils';
import { ActionTypes } from 'constants/Common';
import dispatcher from 'dispatcher';

class BunkerStore extends ReduceStore {
    getInitialState() {
        return new Immutable.Map();
    }

    reduce(state, action) {
        const { data, type } = action;

        switch (type) {
            case ActionTypes.RECEIVE_MIXED_DATA:
                return this._receiveMixedData(data, state);
        }

        return state;
    }

    _receiveMixedData(data, state) {
        if (data.bunker) {
            state = Immutable.fromJS(data.bunker);
        }

        return state;
    }

    getNode(node) {
        const content = this._state.get(node);

        return content ? content.toJS() : null;
    }
}

export default window.ya.connect.BunkerStore = new BunkerStore(dispatcher);
