import Immutable from 'immutable';
import { ReduceStore } from 'flux/utils';
import { ActionTypes } from 'constants/Common';
import dispatcher from 'dispatcher';

class CaptchaStore extends ReduceStore {
    getInitialState() {
        return new Immutable.Map();
    }

    reduce(state, action) {
        const { data, type } = action;

        switch (type) {
            case ActionTypes.RECEIVE_CAPTCHA:
                return state.merge(data);
        }

        return state;
    }

    /**
     * Возвращает путь до картинки с каптчей
     * @method  getSrc
     * @returns {String}
     */
    getSrc() {
        return this.getState().get('src');
    }

    /**
     * Возвращает ключ каптчи
     * @method  getKey
     * @returns {String}
     */
    getKey() {
        return this.getState().get('key');
    }
}

export default window.ya.connect.CaptchaStore = new CaptchaStore(dispatcher);
