/**
 * Хранилище данных o DNS-записях
 */

import Immutable from 'immutable';
import { ReduceStore } from 'flux/utils';
import { ActionTypes } from 'constants/Common';
import dispatcher from 'dispatcher';

class DnsStore extends ReduceStore {
    getInitialState() {
        return new Immutable.Map();
    }

    reduce(state, action) {
        const { data, type } = action;

        switch (type) {
            case ActionTypes.RECEIVE_MIXED_DATA:
                return this._receiveMixedData(state, data);
            case ActionTypes.RECEIVE_DNS_RECORDS:
                return state.merge(Immutable.fromJS(data.dns_records));
            case ActionTypes.DISCARD_DNS_RECORD:
                return state.remove(String(data.id));
        }

        return state;
    }

    _receiveMixedData(state, data) {
        if (data && data.dns_records) {
            return state = Immutable.fromJS(data.dns_records);
        }

        return state;
    }

    /**
     * Возвращает значение по ключу из состояния хранилища
     * @method  get
     * @param   {String}  key
     * @returns {String}
     */
    get(key) {
        return this.getState().getIn(key.split('.'));
    }

    /**
     * Возвращает значение из хранилища по списку ключей
     * @method  get
     * @param   {Array}  keys
     * @returns {String}
     */
    getIn(keys) {
        return this.getState().getIn(keys);
    }

    getRecordType(recordId) {
        return this.getState().getIn([recordId, 'type']);
    }

    /**
     * Возвращает массив отсортированных DNS-записей
     * @returns {Array}
     */
    getList() {
        return this.getState()
            .toList()
            .sortBy(item => item.get('type'))
            .toJS();
    }

    getSoaRecordId() {
        const soaRecord = this.getState().find(record => record.get('type') === 'SOA');

        if (soaRecord) {
            return String(soaRecord.get('id'));
        }
    }
}

export default window.ya.connect.DnsStore = new DnsStore(dispatcher);
