/**
 * Хранилище данных о доступных для пользователя фичах
 */

import _ from 'lodash';
import Immutable from 'immutable';
import { ReduceStore } from 'flux/utils';
import { ActionTypes, FeatureNames } from 'constants/Common';
import dispatcher from 'dispatcher';

class FeatureStore extends ReduceStore {
    getInitialState() {
        return Immutable.fromJS(_.get(window.ya.connect, 'initial.features', {}));
    }

    reduce(state, action) {
        const { data, type } = action;

        switch (type) {
            case ActionTypes.RECEIVE_MIXED_DATA:
                return this._receiveMixedData(state, data);
        }

        return state;
    }

    _receiveMixedData(state, data) {
        if (!data.features) {
            return state;
        }

        return Immutable.fromJS(data.features);
    }

    isEnabled(featureName) {
        return this._state.getIn([featureName, 'enabled']);
    }

    isYO() {
        return this.isEnabled(FeatureNames.CAN_WORK_WITHOUT_OWNED_DOMAINS);
    }
}

export default window.ya.connect.FeatureStore = new FeatureStore(dispatcher);
