import Immutable from 'immutable';
import { ReduceStore } from 'flux/utils';
import { ActionTypes } from 'constants/Common';
import dispatcher from 'dispatcher';

class LicenseStore extends ReduceStore {
    getInitialState() {
        return Immutable.fromJS({});
    }

    reduce(state, action) {
        const { data, type } = action;

        switch (type) {
            case ActionTypes.RECEIVE_MIXED_DATA:
                return this._receiveRawData(state, data);
        }

        return state;
    }

    _receiveRawData(state, data) {
        if (data.licenses !== undefined) {
            state = state.merge(data.licenses);
        }

        return state;
    }

    getCurrentSubscribers(serviceId) {
        const subscribers = this._state.getIn(['subscribers', serviceId]);

        return subscribers ? subscribers.toJS() : [];
    }

    getRequests(serviceId) {
        const requests = this._state.getIn(['requests', serviceId]);

        return requests ? requests.toJS() : [];
    }

    getRequestsCount(serviceId) {
        return this.getRequests(serviceId).length;
    }
}

export default window.ya.connect.LicenseStore = new LicenseStore(dispatcher);
