import Immutable from 'immutable';
import { ReduceStore } from 'flux/utils';
import { ActionTypes } from 'constants/Common';
import dispatcher from 'dispatcher';

const DEFAULT_RAW_STATE = {
    /**
     * Возможность закрыть диалог с клавиатуры + крестик
     * @type {boolean}
     */
    closable: true,

    /**
     * Заголовок диалога
     * @type {string}
     */
    title: '',

    /**
     * Отображение диалога
     * @type {boolean}
     */
    visible: false,

    /**
     * Модификатор класса диалога
     * @type {string}
     */
    mod: undefined,

    /**
     * Обработчик, выполняющийся после закрытия диалога
     * @type {function}
     */
    onClose: null,

    /**
     * Компонент, который будет показан в диалоге
     * @type {React.Component}
     */
    component: null,

    /**
     * Параметры с которыми будет создан компонент в диалоге
     * @type {Object}
     */
    props: null,
};

class ModalStore extends ReduceStore {
    getInitialState() {
        return new Immutable.Map(DEFAULT_RAW_STATE);
    }

    reduce(state, action) {
        const { data, type } = action;

        switch (type) {
            case ActionTypes.OPEN_MODAL_DIALOG:
                return this.clearState(state).merge(data).set('visible', true);
            case ActionTypes.CLOSE_MODAL_DIALOG:
            case ActionTypes.BEFORE_CHANGE_HISTORY:
                return state.set('visible', false);
            case ActionTypes.CLEAR_MODAL_DIALOG:
                return this.clearState(state);
            default:
                return state;
        }
    }

    clearState(state) {
        return state.merge(DEFAULT_RAW_STATE);
    }
}

export default window.ya.connect.ModalStore = new ModalStore(dispatcher);
