import Immutable from 'immutable';
import { ReduceStore } from 'flux/utils';
import { ActionTypes } from 'constants/Common';
import dispatcher from 'dispatcher';

class RestoreStore extends ReduceStore {
    getInitialState() {
        return Immutable.fromJS({
            active_checks: [],
            current_check: {},
            ownership: {},
        });
    }

    reduce(state, action) {
        const { data, type } = action;

        switch (type) {
            case ActionTypes.RECEIVE_MIXED_DATA:
                return data.restore ? state.merge(Immutable.fromJS(data.restore)) : state;
        }

        return state;
    }

    getActiveChecks() {
        return this._state.get('active_checks').toJS();
    }

    getCurrentCheck() {
        return this._state.get('current_check').toJS();
    }

    getOwnershipStatus() {
        return this._state.get('ownership').toJS();
    }
}

export default window.ya.connect.RestoreStore = new RestoreStore(dispatcher);
