/**
 * Хранилище данных о асинхронных тасках в настройках
 */

import Immutable from 'immutable';
import { ReduceStore } from 'flux/utils';
import { ActionTypes } from 'constants/Common';
import dispatcher from 'dispatcher';

class SettingsTasksStore extends ReduceStore {
    getInitialState() {
        return new Immutable.List();
    }

    reduce(state, action) {
        const { data, type } = action;

        switch (type) {
            case ActionTypes.RECEIVE_MIXED_DATA:
                return this._receiveMixedData(state, data.tasks);
            case ActionTypes.RECEIVE_ORGANIZATION_SETTINGS:
                return this._receiveMixedData(state, data.tasks);
        }

        return state;
    }

    _receiveMixedData(state, tasksData) {
        if (!tasksData) {
            return state;
        }

        return new Immutable.List(tasksData);
    }

    /**
     * Есть ли данные о настройках организации
     * @returns {Boolean}
     */
    isEmpty() {
        return this.getState().isEmpty();
    }

    /**
     * Находится ли данный ключ в коллекции задач
     * @method  has
     * @param   {String}  key
     * @returns {Boolean}
     */
    has(key) {
        return this.getState().contains(key);
    }
}

export default window.ya.connect.SettingsTasksStore = new SettingsTasksStore(dispatcher);
