import Immutable from 'immutable';
import { ReduceStore } from 'flux/utils';
import { ActionTypes } from 'constants/Common';
import dispatcher from 'dispatcher';
import ConfigStore from 'stores/Config';

/*
const TEST_PROMOCODES = [
    {
        id: 'XXX298679832476',
        description: 'Скидка 50% на все платные сервисы',
        // status: 'activated',
        expires: '2018-11-13'
    },
    {
        id: 'XXX298679832476',
        description: 'Скидка 50% на все платные сервисы',
        status: 'expired',
        expires: '2018-11-13'
    },
    {
        id: 'XXX298679832476',
        description: 'Скидка 50% на все платные сервисы',
        status: 'expired',
        expires: '2018-11-13'
    }
];
*/

class SubscriptionStore extends ReduceStore {
    getInitialState() {
        return Immutable.fromJS({
            persons: [],
        });
    }

    reduce(state, action) {
        const { data, type } = action;

        switch (type) {
            case ActionTypes.RECEIVE_MIXED_DATA:
                return state.mergeDeep(data.subscription);
        }

        return state;
    }

    get(key) {
        return this.getState().getIn(key.split('.'));
    }

    getPersons() {
        return this._state.get('persons').toJS();
    }

    getPlan() {
        if (!ConfigStore.get('app.isProd')) {
            const value = (location.href.match(/[\?&]plan=([^&]+)/) || [])[1];

            if (value) {
                return value;
            }
        }

        return this.get('current.subscription_plan');
    }

    getBalance() {
        return this.get('current.balance');
    }

    hasContract() {
        return this.get('current.has_contract');
    }

    getPlanInchangeabilityReasons() {
        const reasons = this.getState().getIn([
            'current',
            'subscription_plan_change_requirements',
            'why_not_changeable',
        ]);

        return reasons ? reasons.toJS() : [];
    }

    isPlanChangeable() {
        return !this.getPlanInchangeabilityReasons().length;
    }

    getPricing(serviceId) {
        return new Immutable.Map({ currency: this.getCurrency() })
            .mergeDeep(this._state.getIn(['pricing', 'services', serviceId]))
            .toJS();
    }

    getCurrency() {
        return this._state.getIn(['pricing', 'currency']);
    }

    getCurrentUserCount(serviceId) {
        return this.getCurrentPricing(serviceId).users_count;
    }

    getCurrentPricing(serviceId) {
        return new Immutable.Map({ currency: this.getCurrentCurrency() })
            .mergeDeep(this._state.getIn(['pricing', 'services', serviceId]))
            .toJS();
    }

    getCurrentCurrency() {
        return this._state.getIn(['pricing', 'currency']);
    }

    getAvailablePromoCodes() {
        // return TEST_PROMOCODES;
        const promoCode = this.get('pricing.promocode');

        return promoCode ? [promoCode.toJS()] : [];
    }
}

export default window.ya.connect.SubscriptionStore = new SubscriptionStore(dispatcher);
