import PropTypes from 'prop-types';
import React from 'react';
import classSet from 'classnames';

import './index.css';

const FlatButton = props => {
    const { title, width, className, onClick, ariaLabel } = props;
    const fullClassName = classSet({
        'ui-flat-button': true,
        'ui-flat-button__width_available': width === 'available',
        [className]: Boolean(className),
    });

    return (
        <button
            className={fullClassName}
            title={title}
            onClick={onClick}
            tabIndex="0"
            role="button"
            aria-label={ariaLabel}
        >

            {props.children}
        </button>
    );
};

// @if NODE_ENV='development'
FlatButton.propTypes = {
    title: PropTypes.string,
    width: PropTypes.oneOf(['available']),
    className: PropTypes.string,
    onClick: PropTypes.func,
    ariaLabel: PropTypes.string,
};
// @endif

FlatButton.Label = props => <span className="ui-flat-button__label">{props.children}</span>;

export default FlatButton;
