import PropTypes from 'prop-types';
import classSet from 'classnames';

const Buttons = props => {
    const className = classSet({
        form__buttons: true,
        [`form__buttons_${props.mod}`]: Boolean(props.mod),
        [props.className]: Boolean(props.className),
    });

    return <div className={className}>{props.children}</div>;
};

// @if NODE_ENV='development'
Buttons.propTypes = {
    mod: PropTypes.string,
};
// @endif

export default Buttons;
