import PropTypes from 'prop-types';
import React from 'react';
import classSet from 'classnames';
import './index.css';

const Error = React.createClass({
    render() {
        const { value, mod } = this.props;
        let content;

        const className = classSet({
            form__error: true,
            [`form__error_${mod}`]: Boolean(mod),
        });

        if (value instanceof Array) {
            if (value.length > 1) {
                content = <ul>{value.map((error, index) => <li key={index}>{error}</li>)}</ul>;
            } else if (value.length === 1) {
                content = value[0];
            }
        } else if (value) {
            content = value;
        }

        if (!content) {
            return null;
        }

        return <div className={className} aria-live="polite">{content}</div>;
    },
});

// @if NODE_ENV='development'
Error.propTypes = {
    value: PropTypes.any,
    mod: PropTypes.string,
};
// @endif

export default Error;
