import PropTypes from 'prop-types';
import classSet from 'classnames';
import Label from './Label';
import Error from './Error';

const Item = props => {
    const component = {};
    const className = classSet({
        form__item: true,
        form__item_required: props.required,
        form__item_unlabelled: props.unlabelled,
        [props.className]: Boolean(props.className),
    });

    if (props.label && typeof props.label === 'object') {
        // component
        component.label = props.label;
    } else {
        // html text or primitives
        component.label =
            <Label><span dangerouslySetInnerHTML={{ __html: props.label }} /></Label>;
    }

    if (props.tip) {
        component.tip =
            <div className="form__tip" dangerouslySetInnerHTML={{ __html: props.tip }} />;
    }

    return (
        <div className={className}>
            <div className="form__field">
                {component.label}
                <div className="form__value">
                    {props.children}
                </div>
            </div>
            {component.tip}
            <Error value={props.errors} />
        </div>
    );
};

// @if NODE_ENV='development'
Item.propTypes = {
    label: PropTypes.any,
    errors: PropTypes.any,
    required: PropTypes.bool,
    unlabelled: PropTypes.bool,
};
// @endif

export default Item;
