import PropTypes from 'prop-types';
import classSet from 'classnames';

const Label = props => {
    const className = classSet({
        form__label: true,
        [`form__label_${props.mod}`]: Boolean(props.mod),
    });

    return <div className={className}>{props.children}</div>;
};

// @if NODE_ENV='development'
Label.propTypes = {
    mod: PropTypes.string,
};
// @endif

export default Label;
