import PropTypes from 'prop-types';
import { i18n } from 'lib/i18n';
import ButtonGroup from 'ui/ButtonGroup';

const GENDER_OPTIONS = [{
    text: i18n('common_vocab.gender.male'),
    val: 'male',
}, {
    text: i18n('common_vocab.gender.female'),
    val: 'female',
}];

const GenderPicker = props => (
    <ButtonGroup
        name="gender"
        options={GENDER_OPTIONS}
        mode="optional-single"
        val={props.val}
    />
);

// @if NODE_ENV='development'
GenderPicker.propTypes = {
    val: PropTypes.any,
    name: PropTypes.string,
};
// @endif

export default GenderPicker;
