import PropTypes from 'prop-types';
import React from 'react';
import classSet from 'classnames';
import AppMenu from './AppMenu.jsx';
import { i18n } from 'lib/i18n';

function getUrl(item) {
    return typeof item.url === 'function' ? item.url() : item.url;
}

var Header = props => {
    return (
        <div className="header">
            <div className="header__title-container">
                <AppMenu {...props.appMenu}>
                    <Header.Logo {...props.logo}/>
                    <Header.Title {...props.title}/>
                </AppMenu>
            </div>
            {props.children}
        </div>
    );
};

Header.Logo = props => {
    var component = {};

    if (props.image) {
        component.logoContent = (
            <img src={props.image.src} className="header__logo-image" alt={i18n('common.yandex')}/>
        );
    }

    if (props.url) {
        component.logo = (
            <a className="header__logo header__link"
                href={getUrl(props)}
                target={props.target || '_blank'}
                rel="noopener noreferrer"
                title={props.tip}>
                {component.logoContent}
            </a>
        );
    } else {
        component.logo = (
            <div className="header__logo" title={props.tip} onClick={props.onClick}>
                {component.logoContent}
            </div>
        );
    }

    return component.logo;
};

Header.Title = props => {
    var component = {};

    if (!props) {
        return null;
    }

    if (props.image) {
        component.titleContent = (
            <img src={props.image.src} className="header__title-image" alt={i18n('common.connect')}/>
        );
    } else if (props.text) {
        component.titleContent = (
            <span className="header__title-text">{props.text}</span>
        );
    }

    if (props.url) {
        component.title = (
            <a className="header__title header__link"
                href={getUrl(props)}
                target={props.target}
                title={props.tip}>
                {component.titleContent}
            </a>
        );
    } else {
        component.title = (
            <div className="header__title" title={props.tip} onClick={props.onClick}>
                {component.titleContent}
            </div>
        );
    }

    return component.title;
};

Header.propTypes = {
    appMenu: PropTypes.object,
    logo: PropTypes.shape({
        image: PropTypes.shape({
            src: PropTypes.string
        }),
        url: PropTypes.oneOfType([ PropTypes.string, PropTypes.func ]),
        tip: PropTypes.string,
        onClick: PropTypes.func
    }),
    title: PropTypes.shape({
        image: PropTypes.shape({
            src: PropTypes.string
        }),
        text: PropTypes.string,
        url: PropTypes.oneOfType([ PropTypes.string, PropTypes.func ]),
        tip: PropTypes.string,
        onClick: PropTypes.func
    })
};

Header.defaultProps = {
    logo: {}
};

export default Header;
