import PropTypes from 'prop-types';
import React from 'react';
import PureRenderMixin from 'react-addons-pure-render-mixin';
import classSet from 'classnames';

import './index.css';

const Icon = React.createClass({
    mixins: [PureRenderMixin],

    render() {
        const { type, size, disabled, title, onClick } = this.props;
        const className = classSet({
            'ui-icon': true,
            'ui-icon_disabled': disabled,
            [`ui-icon__${type}`]: true,
            [`ui-icon__size_${size}`]: true,
        });

        return (
            <span
                className={className}
                title={title}
                onClick={disabled ? null : onClick}
            />
        );
    },
});

// @if NODE_ENV='development'
Icon.propTypes = {
    type: PropTypes.oneOf([
        'pen',
        'cross',
        'thin-cross',
        'light-cross',
        'plus',
        'dots',
        'info',
        'blue-info',
        'trash',
        'plus-circle',
        'plus-solid-circle',
        'plus-dark-solid-circle',
        'warning',
        'unavailable',
        'ok',
        'ok-grey',
        'red-question-mark',
        'grey-question-mark',
        'red-cross',
        'status-cross',
        'menu',
        'photo',
        'teams',
        'organization',
        'orgstructure',
        'connect',
        'active',
        'tracker',
        'wiki',
        'forms',
        'calendar',
        'disk',
        'mail',
        'metrika',
        'direct',
        'staff',
        'yamb',
        'question',
        'settings',
        'services',
        'billing',
        'selected',
        'back',
        'copy',
    ]).isRequired,
    size: PropTypes.oneOf(['s', 'm', 'l', 'xl', 'xxl', 'xxxl']),
    title: PropTypes.string,
    disabled: PropTypes.bool,
    onClick: PropTypes.func,
};
// @endif

Icon.defaultProps = {
    size: 'm',
};

export default Icon;
