import _ from 'lodash';
import PropTypes from 'prop-types';
import React from 'react';
import classSet from 'classnames';
import BemInput from 'react-bem-components/lib/Input';

import './index.css';

const Input = React.createClass({

    focus() {
        return this.refs.input.focus();
    },

    select() {
        return this.refs.input.select();
    },

    value() {
        return this.refs.input.value();
    },

    _handleClick() {
        this.focus();
    },

    _adjust() {
        const suffix = this.refs.suffix;

        if (suffix) {
            this.refs.input.block
                .elem('box')
                .css('marginRight', suffix.offsetWidth);
        }
    },

    render() {
        const inputProps = _.omit(this.props, 'suffix');
        let suffix;

        if (this.props.suffix) {
            const suffixClassName = classSet({
                input__suffix: true,
                [`input__suffix__size_${this.props.size}`]: true,
            });

            suffix = <div className={suffixClassName} ref="suffix">{this.props.suffix}</div>;
        }

        return (
            <div className="input__container" onClick={this._handleClick} ref={this._adjust} aria-live="off">
                <BemInput {...inputProps} ref="input" />
                {suffix}
            </div>
        );
    },

});

// @if NODE_ENV='development'
Input.propTypes = {
    suffix: PropTypes.string,
};
// @endif

Input.defaultProps = {
    size: 'm',
};

export default Input;
