import _ from 'lodash';
import PropTypes from 'prop-types';
import React from 'react';

import Popup from 'react-bem-components/lib/Popup';
import ConfigStore from 'stores/Config';

import Link from 'ui/Link';
import Menu from 'ui/Menu';

import ruFlag from '../../../static/i/flag-ru.gif';
import enFlag from '../../../static/i/flag-en.gif';
import trFlag from '../../../static/i/flag-tr.gif';

import './index.css';

function getAcceptedLocales() {
    const data = ConfigStore.get('app.acceptedLocales');

    return data && data.toJS ? data.toJS() : data;
}

function getFlagUrl(lang) {
    switch (lang) {
        case 'ru':
            return ruFlag;
        case 'en':
            return enFlag;
        case 'tr':
            return trFlag;
    }
}

const LangSwitcher = React.createClass({

    componentDidMount() {
        this._anchorPopup();
    },

    componentDidUpdate() {
        this._anchorPopup();
    },

    _anchorPopup() {
        const { languageControl, languagePopup } = this.refs;

        if (languageControl && languagePopup) {
            languagePopup.setAnchor(languageControl);
        }
    },

    _onClick() {
        const { languagePopup } = this.refs;

        if (languagePopup) {
            languagePopup.block.toggleMod('visible');
        }
    },

    _onSelectMenuItem(payload) {
        const { onSelect } = this.props;
        const { languagePopup } = this.refs;

        if (languagePopup) {
            languagePopup.block.setMod('visible', false);
        }

        if (onSelect) {
            onSelect(payload);
        }
    },

    _getText(lang) {
        return _.capitalize(lang);
    },

    _getMenuOptions() {
        const { language: currentLanguage } = this.props;

        return getAcceptedLocales()
            .filter(lang => lang !== currentLanguage)
            .map(lang => ({
                val: lang,
                icon: getFlagUrl(lang),
                text: this._getText(lang),
            }));
    },

    render() {
        const { language: currentLanguage } = this.props;

        return (
            <div className="language-switcher" ref="languageControl">
                <Link onClick={this._onClick} role="button">
                    <img
                        className="language-switcher__flag"
                        src={getFlagUrl(currentLanguage)}
                    />

                    {this._getText(currentLanguage)}
                </Link>
                <Popup
                    ref="languagePopup"
                    closable
                    directions={['top-center']}
                    target="anchor"
                >

                    <div className="language-switcher__menu">
                        <Menu options={this._getMenuOptions()} onSelect={this._onSelectMenuItem} />
                    </div>
                </Popup>
            </div>
        );
    },
});

LangSwitcher.propTypes = {
    language: PropTypes.oneOf(getAcceptedLocales()),
    onSelect: PropTypes.func,
};

export default LangSwitcher;
