import PropTypes from 'prop-types';
import React from 'react';
import PureRenderMixin from 'react-addons-pure-render-mixin';

import './index.css';

const ListItem = React.createClass({
    mixins: [PureRenderMixin],

    render() {
        const { label, value } = this.props;

        return (
            <div className="list-item">
                <div className="list-item__label" title={label}>
                    {label}
                </div>
                <div className="list-item__value" title={value}>
                    {value}
                    {this.props.children}
                </div>
            </div>
        );
    },
});

// @if NODE_ENV='development'
ListItem.propTypes = {
    label: PropTypes.any,
    value: PropTypes.any,
};
// @endif

export default ListItem;
