import PropTypes from 'prop-types';
import React from 'react';
import classSet from 'classnames';

import './index.css';

const OptionList = props => {
    const className = ['ui-option-list', props.className].filter(Boolean).join(' ');

    return <div className={className}>{props.children}</div>;
};

OptionList.Item = React.createClass({

    getInitialState() {
        return { open: this.props.open };
    },

    _handleClick() {
        this.setState({ open: !this.state.open });
    },

    render() {
        const className = classSet({
            'ui-option-list-item': true,
            'ui-option-list-item_open': this.state.open,
        });

        return (
            <div className={className}>
                <div className="ui-option-list-item__title" onClick={this._handleClick}>
                    {this.props.title}
                </div>
                <div
                    className="ui-option-list-item__content"
                    dangerouslySetInnerHTML={{ __html: this.props.content }}
                />
            </div>
        );
    },

});

// @if NODE_ENV='development'
OptionList.Item.propTypes = {
    title: PropTypes.string,
    content: PropTypes.string,
    open: PropTypes.bool,
};
// @endif

OptionList.Item.defaultProps = {
    open: false,
};

export default OptionList;
