import PropTypes from 'prop-types';
import React from 'react';
import './index.css';

function getTailStyle(position) {
    return position ? { marginLeft: position.x, marginTop: position.y } : {};
}

const Popup = React.createClass({
    render() {
        return (
            <div className={`${this.props.className} ui-popup`}>
                <div className="ui-popup__tail" style={getTailStyle(this.props.tailPosition)} />
                <div className="ui-popup__content">
                    {this.props.children}
                </div>
            </div>
        );
    },
});

// @if NODE_ENV='development'
Popup.propTypes = {
    className: PropTypes.string,
};
// @endif

export default Popup;
