import PropTypes from 'prop-types';
import classSet from 'classnames';
import Spin from 'react-bem-components/lib/Spin';

import './index.css';

const Process = props => {
    let caption;
    const className = classSet({
        loader: true,
        loader_visible: props.running,
        loader_transparent: props.transparent,
        loader_tagged: Boolean(props.caption),
    });

    if (props.caption) {
        caption = <span className="loader__caption">{props.caption}</span>;
    }

    return (
        <div className={className}>
            <Spin visible size={props.size} />
            {caption}
        </div>
    );
};

Process.propTypes = {
    running: PropTypes.bool,
    transparent: PropTypes.bool,
};

Process.defaultProps = {
    transparent: true,
};

export default Process;
