import React from 'react';
import ScrollArea from 'ui-externals/ScrollArea';

const SCROLL_EVENT = 'scrollarea-scroll';

const Scrollable = React.createClass({

    getScrollState() {
        return this.refs.scrollArea.state;
    },

    scrollTop() {
        return this.refs.scrollArea.scrollTop();
    },

    scrollBottom() {
        return this.refs.scrollArea.scrollBottom();
    },

    scrollLeft() {
        return this.refs.scrollArea.scrollLeft();
    },

    scrollRight() {
        return this.refs.scrollArea.scrollRight();
    },

    scrollYTo(value) {
        return this.refs.scrollArea.scrollYTo(value);
    },

    _onScroll(value) {
        if (window.dispatchEvent && window.Event) {
            let event;

            if (typeof Event === 'function') {
                event = new Event(SCROLL_EVENT);
            } else {
                // IE, без конструктора Event
                event = document.createEvent('Event');
                event.initEvent(SCROLL_EVENT, true, true);
            }

            window.dispatchEvent(event);
        }

        if (this.props.onScroll) {
            this.props.onScroll(value);
        }
    },

    render() {
        return (
            <ScrollArea
                ref="scrollArea"
                className="section-scrollpane"
                contentClassName="section-content"
                minScrollSize={18}
                {...this.props}
                onScroll={this._onScroll}
            >
                {this.props.children}
            </ScrollArea>
        );
    },

});

export default Scrollable;
