import _ from 'lodash';
import PropTypes from 'prop-types';
import React from 'react';
import classSet from 'classnames';

const Navigation = React.createClass({

    getInitialState() {
        return { index: this.props.index };
    },

    componentWillReceiveProps(nextProps) {
        this.setState(_.pick(nextProps, ['index']));
    },

    _renderButtons() {
        const { onChange, size } = this.props;
        const { index } = this.state;

        const items = [];
        let className;
        let handleClick;

        for (let i = 0; i < size; i++) {
            className = classSet({
                'slider-navigation-button': true,
                'slider-navigation-button_active': i === index,
            });

            if (i !== index) {
                handleClick = (k => () => {
                    this.setState({ index: k });
                    if (onChange) {
                        onChange({ index: k });
                    }
                })(i);
            } else {
                handleClick = null;
            }

            items.push(<div className={className} onClick={handleClick} key={i} />);
        }

        return items;
    },

    render() {
        const buttons = this._renderButtons();

        if (buttons.length < 2) {
            return null;
        }

        return (
            <div className="slider-navigation">
                {buttons}
            </div>
        );
    },

});

// @if NODE_ENV='development'
Navigation.propTypes = {
    index: PropTypes.number,
    size: PropTypes.number,
    onChange: PropTypes.func,
};
// @endif

Navigation.defaultProps = {
    index: 0,
    size: 0,
};

export default Navigation;
