import _ from 'lodash';
import PropTypes from 'prop-types';
import React from 'react';
import classSet from 'classnames';

import './index.css';

const Textarea = React.createClass({

    getInitialState() {
        return {};
    },

    _handleFocus(event) {
        this.setState({ focused: true });

        if (this.props.onFocus) {
            this.props.onFocus(event);
        }
    },

    _handleBlur(event) {
        this.setState({ focused: false });

        if (this.props.onBlur) {
            this.props.onBlur(event);
        }
    },

    render() {
        const { width, size, val, disabled } = this.props;
        const elementProps = _.omit(this.props, ['val', 'width', 'size']);

        const className = classSet({
            textarea: true,
            [`textarea_size_${size}`]: Boolean(size),
            [`textarea_width_${width}`]: Boolean(width),
            textarea_disabled: disabled,
            textarea_focused: this.state.focused,
            textarea_theme_islands: true,
        });

        return (
            <textarea
                {...elementProps}
                className={className}
                onFocus={this._handleFocus}
                onBlur={this._handleBlur}
                defaultValue={val}
                aria-live="off"
            />
        );
    },

});

// @if NODE_ENV='development'
Textarea.propTypes = {
    width: PropTypes.string,
    size: PropTypes.string,
    val: PropTypes.string,
    disabled: PropTypes.bool,
};
// @endif

Textarea.defaultProps = {
    size: 'm',
};

export default Textarea;
