import PropTypes from 'prop-types';
import React from 'react';
import ReactDOM from 'react-dom';
import PureRenderMixin from 'react-addons-pure-render-mixin';
import classSet from 'classnames';

import './index.css';

const Tip = React.createClass({

    mixins: [PureRenderMixin],

    componentDidMount() {
        const tip = ReactDOM.findDOMNode(this);
        const container = tip ? tip.parentNode : null;

        if (tip && container) {
            container.classList.add('ui-tip__container');

            this._on = event => {
                event.preventDefault();
                tip.classList.add('ui-tip__visible');
                container.classList.add('ui-tip__container_active');
            };

            this._off = event => {
                event.preventDefault();
                tip.classList.remove('ui-tip__visible');
                container.classList.remove('ui-tip__container_active');
            };

            switch (this.props.type) {
                case 'rollover':
                    container.addEventListener('mouseenter', this._on);
                    container.addEventListener('mouseleave', this._off);
                    break;

                case 'click':
                    container.addEventListener('click', this._on);
                    document.body.addEventListener('click', this._off);
                    break;
            }
        }
    },

    componentWillUnmount() {
        const tip = ReactDOM.findDOMNode(this);
        const container = tip ? tip.parentNode : null;

        if (container) {
            container.classList.remove('ui-tip__container');

            switch (this.props.type) {
                case 'rollover':
                    container.removeEventListener('mouseenter', this._on);
                    container.removeEventListener('mouseleave', this._off);
                    break;

                case 'click':
                    container.removeEventListener('click', this._on);
                    document.body.removeEventListener('click', this._off);
                    break;
            }
        }
    },

    _renderContent() {
        const { text, children } = this.props;

        if (text) {
            return (
                <div
                    className="ui-tip__content"
                    dangerouslySetInnerHTML={{
                        __html: insertHardSpaces(text),
                    }}
                />
            );
        }

        return (
            <div>
                {children}
            </div>
        );
    },

    render() {
        const className = classSet({
            'ui-tip': true,
            [`ui-tip_theme_${this.props.theme}`]: Boolean(this.props.theme),
            [`ui-tip_position_${this.props.position}`]: true,
        });

        return (
            <div className={className}>
                <div className="ui-tip__tail" />
                {this._renderContent()}
            </div>
        );
    },

});

// @if NODE_ENV='development'
Tip.propTypes = {
    type: PropTypes.oneOf(['rollover', 'click']),
    theme: PropTypes.oneOf(['dark', 'light']),
    position: PropTypes.oneOf(['default', 'top-right', 'middle-left', 'middle-right']),
    text: PropTypes.string,
};
// @endif

Tip.defaultProps = {
    text: '',
    type: 'rollover',
    theme: 'dark',
    position: 'default',
};

// заменяем несколько первых пробелов на неразрывные пробелы,
// чтобы текст в абсолютно спозиционированном блоке не ужимался
// до минимального размера, делая переносы на пробелах;
// min-width не фиксируем, он не позволяет блоку принять размеры
// короткого текста из пары слов

function insertHardSpaces(text) {
    const words = typeof text === 'string' ? text.split(/\s+/) : [];

    return `${words.slice(0, 5).join('\xa0')} ${words.slice(5).join(' ')}`;
}

export default Tip;
