import PropTypes from 'prop-types';
import React from 'react';
import Avatar from 'ui-components/lib/Avatar';
import Tip from 'ui/Tip';

import './index.css';

function shouldRenderDescription(props) {
    return (props.type === 'user' || props.showDescription) && props.description;
}

function getTooltip(props) {
    if (!props.tooltip) {
        return;
    }

    return props.title + (shouldRenderDescription(props) ? `\u00a0| ${props.description}` : '');
}

const Unit = props => {
    const className = [
        'unit',
        props.size ? `unit_size-${props.size}` : null,
        props.type ? `unit_type-${props.type}` : null,
    ].filter(Boolean).join(' ');

    let avatar = <Unit.Avatar {...props} />;

    if (props.avatarTooltip) {
        avatar = (
            <div className="unit__avatar-tooltip">
                {avatar}
                <Tip theme="light">
                    <div className="unit__avatar-tooltip-content">
                        {props.avatarTooltip}
                    </div>
                </Tip>
            </div>
        );
    }

    return (
        <div className={className} title={getTooltip(props)}>
            {avatar}
            <div className="unit__details">
                <Unit.Title {...props} />
                <Unit.Description {...props} />
            </div>
        </div>
    );
};

Unit.Avatar = React.createClass({

    getInitialState() {
        return {};
    },

    componentDidMount() {
        this._mounted = true;

        let image;

        if (this.props.avatar) {
            image = new Image();
            image.onload = () => {
                if (this._mounted) {
                    this.setState({ complete: true });
                }
            };
            image.src = this.props.avatar;
        }

        this.setState({ complete: !image || image.complete });
    },

    componentWillUnmount() {
        this._mounted = false;
    },

    render() {
        const { avatar, size, role } = this.props;

        if (!avatar) {
            return null;
        }

        const className = [
            'unit__avatar',
            this.state.complete ? 'unit__avatar_complete' : null,
            role ? `user-avatar_${role}` : null,
        ].filter(Boolean).join(' ');

        return (
            <div className={className}>
                <Avatar url={avatar} size={size} />
            </div>
        );
    },

});

Unit.Title = props => (
    <div className="unit__title">
        {props.title}
    </div>
);

Unit.Description = props => {
    if (!shouldRenderDescription(props)) {
        return null;
    }

    return (
        <div className="unit__description">
            {props.description}
        </div>
    );
};

Unit.defaultProps = {
    tooltip: true,
    size: 's',
    showDescription: false,
};

Unit.propTypes = {
    avatar: PropTypes.string,
    description: PropTypes.string,
    title: PropTypes.string.isRequired,
    role: PropTypes.string,
    container: PropTypes.bool,
    tooltip: PropTypes.bool,
    showDescription: PropTypes.bool,
    avatarTooltip: PropTypes.string,
};

export default Unit;
