import { i18n } from 'lib/i18n';
import getErrorMap from './getErrorMap';

const domainValidator = {

    getNameError(data) {
        if (!data.name) {
            return i18n('domain.error.add.empty_domain');
        }

        // в доменном имени обязательно должна быть точка
        if (data.name && data.name.indexOf('.') === -1) {
            return i18n('domain.error.add.bad_domain');
        }

        return null;
    },

};

domainValidator.getErrors = getErrorMap(domainValidator);

export default domainValidator;
