import _ from 'lodash';
import Immutable from 'immutable';

const VALIDATION_METHOD_NAME_PATTERN = /^get(\w+)Error$/;

/**
 * Создает для указанного валидатора список валидируемых полей и возвращает метод,
 * создающий Map ошибок
 * @method   getErrorMap
 * @param    {Object}  validator
 * @returns  {function}
 */
function getErrorMap(validator) {
    const validationKeys = [];

    _.each(validator, (value, prop) => {
        // 'getValidationKeyError' => 'validationKey'
        const key = _.camelCase(
            (String(prop).match(VALIDATION_METHOD_NAME_PATTERN) || [])[1] || ''
        );

        if (key) {
            validationKeys.push({ name: key, method: prop });
        }
    });

    return (data, locale = 'ru') => {
        if (!data) {
            return new Immutable.Map();
        }

        // Map({ key: getKeyError(data, locale) })
        return new Immutable.Map(
            validationKeys
                // key => [ key, getKeyError() ]
                .map(key => {
                    let error;

                    if (validator[key.method]) {
                        error = validator[key.method](data, locale);
                    }

                    return [key.name, error];
                })
                // не включаем поля с пустыми значениями ошибок
                .filter(field => Boolean(field[1]))
        );
    };
}

export default getErrorMap;
