import _ from 'lodash';
import { i18n } from 'lib/i18n';
import getErrorMap from './getErrorMap';

function xi18n(key, options) {
    return i18n(`group_validation.${key}`, options);
}

const groupValidator = {

    getNameError(data, locale = 'ru') {
        const minLength = 2;
        const maxLength = 40;

        let name = _.get(data, `name.${locale}`);

        if (name === undefined) {
            return null;
        }

        name = _.trim(name);

        if (!name || name.length < minLength || name.length > maxLength) {
            return xi18n('name_length_out_of_bounds', { minLength, maxLength });
        }

        return null;
    },

    getDescriptionError(data, locale = 'ru') {
        const maxLength = 100;

        const description = _.get(data, `description.${locale}`);

        if (description === undefined) {
            return null;
        }

        if (description.length > maxLength) {
            return xi18n('description_too_long', { maxLength });
        }

        return null;
    },

    getAdminsError(data) {
        if (data.admins === undefined) {
            return null;
        }

        if (!data.admins || !data.admins.length) {
            return xi18n('no_admins');
        }

        return null;
    },

};

groupValidator.getErrors = getErrorMap(groupValidator);

export default groupValidator;
