import validator from 'validator';
import { i18n } from 'lib/i18n';
import getErrorMap from './getErrorMap';

const EMAILS_LIST_MAX_LENGTH = 50;

const inviteValidator = {
    getEmailsError({ splitEmails, emailList }) {
        if (!splitEmails.length && !emailList.length) {
            return i18n('invites.validation.invalid_email');
        }

        if (!splitEmails.length) {
            return null;
        }

        const invalidEmails = splitEmails.filter(item => !validator.isEmail(String(item)));

        if (!invalidEmails.length) {
            return null;
        }

        if (splitEmails.length === 1) {
            return i18n('invites.validation.invalid_email');
        }

        return `${i18n('invites.validation.invalid_emails')} ${invalidEmails.join(' ')}`;
    },

    getEmailListError({ splitEmails, emailList }) {
        if (!emailList) {
            return null;
        }

        let emailListLength = emailList.length;

        /*
        * Случай, когда сумма валидных адресов в инпуте и тех,
        * что уже добавлены в список, больше EMAILS_LIST_MAX_LENGTH
        * при нажатии по кнопке Готово
        */
        if (splitEmails) {
            emailListLength += splitEmails.length;
        }

        if (emailListLength > EMAILS_LIST_MAX_LENGTH) {
            return i18n('invites.validation.too_many_emails', { maxLength: EMAILS_LIST_MAX_LENGTH });
        }

        return null;
    },
};

inviteValidator.getErrors = getErrorMap(inviteValidator);

export default inviteValidator;
