import validator from 'validator';
import { i18n } from 'lib/i18n';
import getErrorMap from './getErrorMap';

const maxLength = {
    FIRST_NAME: 170,
    MIDDLE_NAME: 170,
    LAST_NAME: 170,
    PHONE: 256,
    EMAIL: 256,
};

const naturalPersonValidator = {

    getFirstNameError(data) {
        const { first_name: firstName } = data;

        if (!firstName) {
            return i18n('subscription_validation.natural_person.first_name_undefined');
        }

        if (firstName.length > maxLength.FIRST_NAME) {
            return i18n('subscription_validation.natural_person.first_name_too_long', {
                maxLength: maxLength.FIRST_NAME,
            });
        }

        return null;
    },

    getMiddleNameError(data) {
        const { middle_name: middleName } = data;

        if (!middleName) {
            return i18n('subscription_validation.natural_person.middle_name_undefined');
        }

        if (middleName.length > maxLength.MIDDLE_NAME) {
            return i18n('subscription_validation.natural_person.middle_name_too_long', {
                maxLength: maxLength.MIDDLE_NAME,
            });
        }

        return null;
    },

    getLastNameError(data) {
        const { last_name: lastName } = data;

        if (!lastName) {
            return i18n('subscription_validation.natural_person.last_name_undefined');
        }

        if (lastName.length > maxLength.LAST_NAME) {
            return i18n('subscription_validation.natural_person.last_name_too_long', {
                maxLength: maxLength.LAST_NAME,
            });
        }

        return null;
    },

    getPhoneError(data) {
        const { phone } = data;

        if (!phone) {
            return i18n('subscription_validation.common.phone_undefined');
        }

        if (phone.length > maxLength.PHONE) {
            return i18n('subscription_validation.common.phone_too_long', {
                maxLength: maxLength.PHONE,
            });
        }

        return null;
    },

    getEmailError(data) {
        const { email } = data;

        if (!email) {
            return i18n('subscription_validation.common.email_undefined');
        }

        if (!validator.isEmail(email)) {
            return i18n('subscription_validation.common.invalid_email');
        }

        if (email.length > maxLength.EMAIL) {
            return i18n('subscription_validation.common.email_too_long', {
                maxLength: maxLength.EMAIL,
            });
        }

        return null;
    },

};

naturalPersonValidator.getErrors = getErrorMap(naturalPersonValidator);

export default naturalPersonValidator;
