/**
 * Валидация данных пользователя, полученных из окна подписки
 */

import validator from 'validator';
import { i18n } from 'lib/i18n';
import getErrorMap from './getErrorMap';

const senderValidator = {

    getEmailError(data) {
        if (data.isAnotherEmailSet && !validator.isEmail(String(data.emailContent))) {
            return i18n('news_mail_subscription.errors.email');
        }
    },

};

senderValidator.getErrors = getErrorMap(senderValidator);

export default senderValidator;
