/**
 * Валидация данных из профиля организации
 */

import validator from 'validator';
import { i18n } from 'lib/i18n';
import getErrorMap from './getErrorMap';

function xi18n(key, options) {
    return i18n(`organization_profile_validation.${key}`, options);
}

const orgProfileValidator = {

    getNameError({ name }) {
        if (!name) {
            return xi18n('invalid_name');
        }
    },

    getEmailError(data) {
        if (data.email && !validator.isEmail(data.email)) {
            return xi18n('invalid_email');
        }
    },

    getPhoneNumberError(data) {
        if (data.phone_number && !/^\+?\d+$/.test(data.phone_number)) {
            return xi18n('invalid_phone_number');
        }
    },

    getFaxError(data) {
        if (data.fax && !/^\+?\d+$/.test(data.fax)) {
            return xi18n('invalid_fax');
        }
    },

};

orgProfileValidator.getErrors = getErrorMap(orgProfileValidator);

export default orgProfileValidator;
