import validator from 'validator';
import { i18n } from 'lib/i18n';
import Url from 'lib/Url';
import getErrorMap from './getErrorMap';

const orgSetupValidator = {

    getNameError(data) {
        if (!data.name) {
            return i18n('organization_setup_validation.name_undefined');
        }
    },

    getLanguageError(data) {
        if (!data.language) {
            return i18n('organization_setup_validation.language_undefined');
        }
    },

    getCountryError(data) {
        if (!data.country) {
            return i18n('organization_setup_validation.country_undefined');
        }
    },

    getEmailError(data) {
        if (!data.email) {
            return i18n('organization_setup_validation.email_undefined');
        }
        if (!validator.isEmail(data.email) || !Url.isSafe(data.email)) {
            return i18n('organization_setup_validation.email_invalid');
        }
    },

};

orgSetupValidator.getErrors = getErrorMap(orgSetupValidator);

export default orgSetupValidator;
